/*
 * Decompiled with CFR 0.152.
 */
package net.dragonloot.entity;

import net.dragonloot.init.EntityInit;
import net.dragonloot.init.ItemInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DragonTridentEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> LOYALTY = SynchedEntityData.m_135353_(DragonTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ENCHANTED = SynchedEntityData.m_135353_(DragonTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack tridentStack = new ItemStack((ItemLike)ItemInit.DRAGON_TRIDENT_ITEM);
    private boolean dealtDamage;
    public int returnTimer;

    public DragonTridentEntity(EntityType<? extends DragonTridentEntity> entityType, Level world) {
        super(entityType, world);
    }

    public DragonTridentEntity(Level world, LivingEntity owner, ItemStack stack) {
        super(EntityInit.DRAGONTRIDENT_ENTITY, owner, world);
        this.tridentStack = stack.m_41777_();
        this.f_19804_.m_135381_(LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)stack)));
        this.f_19804_.m_135381_(ENCHANTED, (Object)stack.m_41790_());
    }

    @Environment(value=EnvType.CLIENT)
    public DragonTridentEntity(Level world, double x, double y, double z) {
        super(EntityInit.DRAGONTRIDENT_ENTITY, x, y, z, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ENCHANTED, (Object)false);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        if ((this.dealtDamage || this.m_36797_()) && entity != null) {
            byte i = (Byte)this.f_19804_.m_135370_(LOYALTY);
            if (i > 0 && !this.isOwnerAlive()) {
                if (!this.m_9236_().m_5776_() && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else if (i > 0) {
                this.m_36790_(true);
                Vec3 vec3d = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20188_() - this.m_20186_(), entity.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3d.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().m_5776_()) {
                    this.f_19791_ = this.m_20186_();
                }
                double d = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3d.m_82541_().m_82490_(d)));
                if (this.returnTimer == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.returnTimer;
            }
        }
        super.m_8119_();
    }

    private boolean isOwnerAlive() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.tridentStack.m_41777_();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isEnchanted() {
        return (Boolean)this.f_19804_.m_135370_(ENCHANTED);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 currentPosition, Vec3 nextPosition) {
        return this.dealtDamage ? null : super.m_6351_(currentPosition, nextPosition);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        float f = 8.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.tridentStack, (MobType)livingEntity.m_6336_());
        }
        Entity entity2 = this.m_19749_();
        Level world = entity.m_9236_();
        DamageSource damageSource = world.m_269111_().m_269525_((Entity)this, (Entity)(entity2 == null ? this : entity2));
        this.dealtDamage = true;
        SoundEvent soundEvent = SoundEvents.f_12514_;
        if (entity.m_6469_(damageSource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                if (entity2 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity2, (Entity)entity2);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity2), (Entity)livingEntity2);
                }
                this.m_7761_(livingEntity2);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float g = 1.0f;
        if (this.m_9236_() instanceof ServerLevel && this.m_9236_().m_46470_() && EnchantmentHelper.m_44936_((ItemStack)this.tridentStack)) {
            BlockPos blockPos = entity.m_20183_();
            if (this.m_9236_().m_45527_(blockPos)) {
                LightningBolt lightningEntity = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                lightningEntity.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
                lightningEntity.m_20879_(entity2 instanceof ServerPlayer ? (ServerPlayer)entity2 : null);
                this.m_9236_().m_7967_((Entity)lightningEntity);
                soundEvent = SoundEvents.f_12521_;
                g = 5.0f;
            }
        }
        this.m_5496_(soundEvent, g, 1.0f);
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player player) {
        Entity entity = this.m_19749_();
        if (entity == null || entity.m_20148_() == player.m_20148_()) {
            super.m_6123_(player);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Dragon_Trident", 10)) {
            this.tridentStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Dragon_Trident"));
        }
        this.dealtDamage = tag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.tridentStack)));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Dragon_Trident", (Tag)this.tridentStack.m_41739_(new CompoundTag()));
        tag.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean m_6000_(double cameraX, double cameraY, double cameraZ) {
        return true;
    }
}

